/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.sound.generator.MineLP;
import eu.ha3.presencefootsteps.sound.generator.Modifier;
import eu.ha3.presencefootsteps.sound.generator.QuadrupedModifier;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.TerrestrialStepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.WingedStepSoundGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_746;

public enum Locomotion {
    NONE,
    BIPED(() -> new TerrestrialStepSoundGenerator(new Modifier<TerrestrialStepSoundGenerator>())),
    QUADRUPED(() -> new TerrestrialStepSoundGenerator(new QuadrupedModifier())),
    FLYING(() -> new WingedStepSoundGenerator(new QuadrupedModifier())),
    FLYING_BIPED(() -> new WingedStepSoundGenerator(new Modifier<TerrestrialStepSoundGenerator>()));

    private static final Map<String, Locomotion> registry;
    private final Supplier<Optional<StepSoundGenerator>> constructor;
    private static final String AUTO_TRANSLATION_KEY = "menu.pf.stance.auto";
    private final String translationKey = "menu.pf.stance." + this.name().toLowerCase();

    private Locomotion() {
        this.constructor = Optional::empty;
    }

    private Locomotion(Supplier<StepSoundGenerator> gen) {
        this.constructor = () -> Optional.of((StepSoundGenerator)gen.get());
    }

    public Optional<StepSoundGenerator> supplyGenerator() {
        return this.constructor.get();
    }

    public class_2561 getOptionName() {
        return new class_2588("menu.pf.stance", new Object[]{new class_2588(this == NONE ? AUTO_TRANSLATION_KEY : this.translationKey)});
    }

    public class_2561 getOptionTooltip() {
        return new class_2588(this.translationKey + ".tooltip");
    }

    public String getDisplayName() {
        return class_1074.method_4662((String)"pf.stance", (Object[])new Object[]{class_1074.method_4662((String)this.translationKey, (Object[])new Object[0])});
    }

    public static Locomotion byName(String name) {
        return registry.getOrDefault(name, BIPED);
    }

    public static Locomotion forLiving(class_1297 entity, Locomotion fallback) {
        if (MineLP.hasPonies()) {
            return MineLP.getLocomotion(entity, fallback);
        }
        return fallback;
    }

    public static Locomotion forPlayer(class_1657 ply, Locomotion preference) {
        if (preference == NONE) {
            if (ply instanceof class_746 && MineLP.hasPonies()) {
                return MineLP.getLocomotion(ply);
            }
            return BIPED;
        }
        return preference;
    }

    static {
        registry = new HashMap<String, Locomotion>();
        for (Locomotion i : Locomotion.values()) {
            registry.put(i.name(), i);
            registry.put(String.valueOf(i.ordinal()), i);
        }
    }
}

